/* $Id: src_dnld.c,v 1.6 1998/07/21 21:41:47 ericb Exp $*/
/* Copyright (C) 1996 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Don Mathiesen */


/* test for source signal program download */
/*	copy randbb2.bin from arbsrc dir to current dir */
/*	run test : src_dnld -f randbb2.bin		*/
/*	this should start a cont random instead of default, sine */


#include <stdlib.h>		/* For exit */
#include <stdio.h>		/* For printf */
#include <string.h>		/* For strcmp */
#include <unistd.h>		/* For sleep, read */
#include "e1432.h"

#define NMOD_MAX		8
#define NCHAN_MAX		(NMOD_MAX * E1432_CHANS)

/* Wrap this around all the many function calls which might fail */
#ifdef	__lint
#define CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	(void) fprintf(stderr, "Error: %s returned %d\n", #func, _s);\
	return _s;\
    }\
} while (func)
#else
#define CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	(void) fprintf(stderr, "Error: %s returned %d\n", #func, _s);\
	return _s;\
    }\
} while (0)
#endif

#define SRCCMDV_EXTMSG		0xa2a2a2a2UL
#define SRCCMDV_CMDMODE		0xa3a3a3a3UL
#define SRCCMDV_SRCON		0xB1B1B1B1UL

#define SRCCMD_BLOCKWRITE	0x0000000eUL
#define SRC_BLOCKWRITE_Y_SPACE	0x00000000UL
#define SRC_BLOCKWRITE_X_SPACE	0x00000001UL
#define SRC_BLOCKWRITE_P_SPACE	0x00000002UL
#define SRC_BLOCKWRITE_SIGADDR	0x00000068UL

#define SRCCMD_SIGMODE		0x00000011UL
#define SRC_SIGMODE_CLR		0x00000000UL
#define SRC_SIGMODE_DNLD	0x00400012UL

#define SRCCMD_USERSTORE	0x0000000BUL
#define SRCCMD_USERCLR		0x0000000CUL
#define SRCCMD_USERPWD		0x001D0001UL

/*###########################################################*/

void
xfr_2src(E1432ID lhw, SHORTSIZ16 chanID, LONGSIZ32 numwords, LONGSIZ32
	 *dptr, LONGSIZ32 mode)

{
    LONGSIZ32 i, words_left, xfrsize, maxtries;
    SHORTSIZ16 error;
    /*LONGSIZ32 xfrbuf_wds = 0;*/
    /*LONGSIZ32 srcbuf_state_A = 0;*/
    /*LONGSIZ32 srcbuf_state_B = 0;*/
    /*LONGSIZ32 srcbuf_state_AB = 0;*/

    (void)printf("\nxfr_2src: mode %d, numwords %d\n",mode,numwords);
    (void)printf("buf[0-3]: %x, %x, %x, %x\n",dptr[0],dptr[1],dptr[2],dptr[3]);

    words_left = numwords;
    i = 0;
    maxtries = 2;

    while (words_left > 0)
    {
	if (words_left <= E1432_SRC_DATA_NUMWORDS_MAX)
	    xfrsize = words_left;
	else
	    xfrsize = E1432_SRC_DATA_NUMWORDS_MAX;

	/* write  xfrsize words to the substrate */
/*
	    e1432_get_src_arbstates(lhw,chanID,&xfrbuf_wds,&srcbuf_state_AB,
				    &srcbuf_state_A,&srcbuf_state_B);
	    (void) printf("src_arbstates: lhw %d,chanID %d,xfrbuf_wds %d,srcbuf_state_AB %d,srcbuf_state_A %d,srcbuf_state_B %d\n",lhw,chanID,xfrbuf_wds,srcbuf_state_AB,srcbuf_state_A,srcbuf_state_B);
*/
	(void) printf("	   e1432_write_srcbuffer_data() mode %d, xfrsize %d\n",mode,xfrsize);
	error = e1432_write_srcbuffer_data(lhw, chanID,
					   dptr,
					   (SHORTSIZ16) xfrsize,
					   (SHORTSIZ16) mode);
	(void) printf("	   e1432_write_srcbuffer_data returns: %d\n",error);
	if (error != 0)
	{
/*
	    e1432_get_src_arbstates(lhw,chanID,&xfrbuf_wds,&srcbuf_state_AB,
				    &srcbuf_state_A,&srcbuf_state_B);
	    (void) printf("src_arbstates: lhw %d,chanID %d,xfrbuf_wds %d,srcbuf_state_AB %d,srcbuf_state_A %d,srcbuf_state_B %d\n",lhw,chanID,xfrbuf_wds,srcbuf_state_AB,srcbuf_state_A,srcbuf_state_B);
*/
	    i=i+1;
	    if (i == maxtries)
	    {
		(void) printf("xfr_src_data:	write with wait, timed out \n");
		return;
	    }
	    (void) sleep (1);
	}
	else
	{
	    i=0;
	    dptr = dptr + xfrsize;
	    words_left = words_left - xfrsize;
	}
    }
}

/*###########################################################*/
/*###########################################################*/

int
main (int argn, char **argv)
{
    int opt;		   /* really char returned */
    int rtn;
    int i, chan, error;
    int nchan = 0;
    float ftmp;
    E1432ID hw;
    SHORTSIZ16 modules = 1;
    struct e1432_hwconfig hwconfig[NMOD_MAX];
    SHORTSIZ16 laddr[NMOD_MAX] = { 8 };	/* default logical address */
    SHORTSIZ16 group;
    SHORTSIZ16 chan_list[NCHAN_MAX];
    LONGSIZ32 trapDownload = 0x0c0000; /* jmp <0 */
    LONGSIZ32 *dptr = &trapDownload;
    LONGSIZ32 dsize = sizeof(trapDownload);
    LONGSIZ32 bufr[81];
    char *file_name = NULL;
    off_t file_size;
    int file_des;
    int la_override = 0;

    while ( ( opt = getopt(argn, argv, "c:f:uL:") ) != EOF )
    {
	switch (opt)
	{
	case 'c':
	    rtn = sscanf(optarg, "%f", &ftmp);
	    if ( rtn == 1 )
	    {
		chan = (int)(ftmp + .5);
		chan_list[nchan++] = E1432_SOURCE_CHAN(chan);
	    }
	    else
	    {
		(void) fprintf(stderr,"channel %s not converted\n",
		  optarg);
		exit(2);
	    }
	    break;
	case 'f':
	    file_name = optarg;
	    break;
	case 'L':
	    rtn = sscanf(optarg, "%f", &ftmp);
	    if ( rtn == 1 )
	    {
		if ( ! la_override )
		{
		    la_override = 1;
		    modules = 0;
		}
		laddr[modules++] = (int)(ftmp + .5);
	    }
	    else
	    {
		(void) fprintf(stderr,"logical address %s not converted\n",
		  optarg);
		exit(2);
	    }
	    break;
	default:
	    (void) fprintf(stderr,"usage: %s [options] -f file\n",argv[0]);
	    (void) fprintf(stderr,"options:\n");
	    (void) fprintf(stderr,"    -c channel (default = all channels)\n");
	    (void) fprintf(stderr,"    -L logical address (default = %d)\n",
			   laddr[0]);
	    exit(2);
	}
    }

    if ( file_name != NULL )
    {
	CHECK(i1432_open_file(file_name, &file_des, &file_size));
	dsize = file_size;
	(void)printf("filename = %s, file_size = %d\n",file_name,file_size);
	dptr = (LONGSIZ32 *) malloc(file_size);
	if (dptr == NULL)
	{
	    (void) fprintf(stderr,"malloc failure\n");
	    exit(2);
	}
	if (read(file_des, dptr, file_size) != (int) file_size)
	{
	    (void) fprintf(stderr,"file read failure\n");
	    exit(2);
	}
    }
    else
    {
	(void)printf("no file specified, use -f filename\n");
	return(1);
    }

    /* shift words left since only top 3 bytes sent to 56000 */
    for (i=0; i<file_size/4; i++) dptr[i]= dptr[i] << 8;

    /* Initialize the library */
    CHECK(e1432_init_io_driver());

    /* Change this 0 to 1 to see call tracing */
    e1432_trace_level(0);

    /* Use e1432_get_hwconfig to see if the module already has
       firmware.  If this errors, assume we need to install firmware,
       so use e1432_install to do it. */

    error = e1432_get_hwconfig(modules, laddr, hwconfig);
    if (error != 0)
    {
	(void) printf("downloading /opt/e1432/lib/sema.bin\n");
	error = e1432_install(modules, laddr, 0,
			      "/opt/e1432/lib/sema.bin");
	if (error)
	{
	    (void) fprintf(stderr, "e1432_install failed, error: %d\n", error);
	    return -1;
	}

	CHECK(e1432_get_hwconfig(modules, laddr, hwconfig));
    }

    /* Turn on debugging prints, a good idea while developing.	But do
       it after the above e1432_get_hwconfig, because we know that
       might error if the firmware is not yet installed in the
       module. */
    (void) e1432_print_errors(1);

    e1432_debug_level(0);

    CHECK(e1432_assign_channel_numbers(modules, laddr, &hw));

    /* Create channel group */
    if ( nchan < 1 )  /* doing all channels */
    {
	for ( i = 0; i < modules; i++ ) nchan += hwconfig[i].source_chans;
	if (nchan > NCHAN_MAX) nchan = NCHAN_MAX;
	for (i = 0; i < nchan; i++)
	{
	    chan_list[i] = E1432_SOURCE_CHAN(i+1);
	}
    }

    group = e1432_create_channel_group(hw, nchan, chan_list);
    if (group >= 0)
    {
	(void) printf("e1432_create_channel_group group returned %d\n",
		      group);
	return -1;
    }

/*    CHECK(e1432_sca_dsp_download(hw, group, dsize, dptr));
*/

    CHECK(e1432_set_active(hw, group, E1432_CHANNEL_ON));

    CHECK(e1432_set_srcbuffer_init(hw, group,E1432_SRCBUFFER_INIT_XFER));

    /*###########################################################*/
    /* send reset measure */
    CHECK(e1432_reset_measure(hw, group));

    /*###########################################################*/
    /* test send source on */

/*
    bufr[0] = SRCCMDV_SRCON;
	xfr_2src(hw, chan_list[0], 1, bufr,
		 E1432_SRC_DATA_MODE_RAWCMD);
*/

    /*###########################################################*/
    /* download for all channel in the list */
    for (i = 0; i < nchan; i++)
    {
	/*************************************************************/
	/* read id and sisr status */
	bufr[0] = 0;
	xfr_2src(hw, chan_list[i], 1, bufr,
		 E1432_SRC_DATA_MODE_READID);
	(void)printf("source ID reg: %x\n",bufr[0]);

	bufr[0] = 0;
	xfr_2src(hw, chan_list[i], 1, bufr,
		 E1432_SRC_DATA_MODE_READSTATUS);
	(void)printf("source SISR reg: %x\n",bufr[0]);

	/*************************************************************/
	/* send cmd to put source in hostport in command buffer mode */
	bufr[0] = SRCCMDV_CMDMODE;
	xfr_2src(hw, chan_list[i], 1, bufr,
		 E1432_SRC_DATA_MODE_RAWCMD);

	/*************************************************************/
	/* send extended message (data and cmd) to clr signal mode */
	/* ##############  use host library command */
/*
	bufr[0] = SRCCMD_SIGMODE<<8;
	bufr[1] = SRC_SIGMODE_CLR<<8;
	xfr_2src(hw, chan_list[i], 2, bufr,
		 E1432_SRC_DATA_MODE_RAWDATA);
	bufr[0] = SRCCMDV_EXTMSG;
	xfr_2src(hw, chan_list[i], 1, bufr,
		 E1432_SRC_DATA_MODE_RAWCMD);
*/
	CHECK(e1432_set_source_mode(hw,group, E1432_SOURCE_MODE_DNLD));

	/*************************************************************/
	/* send extended message (data and cmd) to set up program transfer */
	bufr[0] = SRCCMD_BLOCKWRITE<<8;
	bufr[1] = SRC_BLOCKWRITE_P_SPACE<<8;
	bufr[2] = SRC_BLOCKWRITE_SIGADDR<<8;
	xfr_2src(hw, chan_list[i], 3, bufr,
		 E1432_SRC_DATA_MODE_RAWDATA);
	bufr[0] = SRCCMDV_EXTMSG;
	xfr_2src(hw, chan_list[i], 1, bufr,
		 E1432_SRC_DATA_MODE_RAWCMD);

	/*************************************************************/
	/* transfer data */

	xfr_2src(hw, chan_list[i], dsize/4,dptr,E1432_SRC_DATA_MODE_RAWDATA);

	/*************************************************************/
	/* end by transfer: send cmd to put source in hostport in command buffer mode */
	bufr[0] = SRCCMDV_CMDMODE;
	xfr_2src(hw, chan_list[i], 1, bufr,
		 E1432_SRC_DATA_MODE_RAWCMD);

	/*************************************************************/
	/* send extended message (data and cmd) dnld signal mode */
	/* ##############  use host library command */
/*
	bufr[0] = SRCCMD_SIGMODE<<8;
	bufr[1] = SRC_SIGMODE_DNLD<<8;
	xfr_2src(hw, chan_list[i], 2, bufr,
		 E1432_SRC_DATA_MODE_RAWDATA);
	bufr[0] = SRCCMDV_EXTMSG;
	xfr_2src(hw, chan_list[i], 1, bufr,
		 E1432_SRC_DATA_MODE_RAWCMD);

	see below: CHECK(e1432_set_source_mode(hw,chan_list[i], E1432_SOURCE_MODE_DNLD));
*/

	/*###########################################################*/
	/* test send source on */
/*
	bufr[0] = SRCCMDV_SRCON;
	xfr_2src(hw, chan_list[i], 1, bufr,
		 E1432_SRC_DATA_MODE_RAWCMD);

	see below:  CHECK(e1432_init_measure(hw, group));
*/

	/*************************************************************/
	/* read sisr status */
/*
	(void) sleep(1);
	bufr[0] = 0;
	xfr_2src(hw, chan_list[i], 1, bufr,
		 E1432_SRC_DATA_MODE_READSTATUS);
	(void)printf("source SISR reg: %x\n",bufr[0]);
*/

    }	/* end download to all channels in the list */

    /* turn on source(s) */
    CHECK(e1432_set_active(hw, group, E1432_CHANNEL_ON));
    CHECK(e1432_set_source_mode(hw,group, E1432_SOURCE_MODE_DNLD));
    CHECK(e1432_init_measure(hw, group));

    (void) sleep (1);

    /*************************************************************/
    /* read sisr status */
    for (i = 0; i < nchan; i++)
    {
	bufr[0] = 0;
	xfr_2src(hw, chan_list[i], 1, bufr,
		 E1432_SRC_DATA_MODE_READSTATUS);
	(void)printf("source SISR reg: %x\n",bufr[0]);
    }

    (void) sleep (1);

/*
    CHECK(e1432_reset_measure(hw, group));
*/

    return 0;
}
